/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.block.wood;

import com.teamabnormals.blueprint.core.util.BlockUtil;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class WoodPostBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_X = WoodPostBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_Y = WoodPostBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_Z = WoodPostBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    private static final BooleanProperty[] CHAINED = new BooleanProperty[]{BooleanProperty.m_61465_((String)"chain_down"), BooleanProperty.m_61465_((String)"chain_up"), BooleanProperty.m_61465_((String)"chain_north"), BooleanProperty.m_61465_((String)"chain_south"), BooleanProperty.m_61465_((String)"chain_west"), BooleanProperty.m_61465_((String)"chain_east")};
    private final Supplier<Block> block;

    public WoodPostBlock(BlockBehaviour.Properties properties) {
        this(null, properties);
    }

    public WoodPostBlock(Supplier<Block> block, BlockBehaviour.Properties properties) {
        super(properties);
        this.block = block;
        BlockState defaultState = (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y);
        for (BooleanProperty prop : CHAINED) {
            defaultState = (BlockState)defaultState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(defaultState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.X -> SHAPE_X;
            case Direction.Axis.Y -> SHAPE_Y;
            default -> SHAPE_Z;
        };
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getRelevantState(context.m_43725_(), context.m_8083_(), context.m_43719_().m_122434_());
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState newState = this.getRelevantState(worldIn, pos, (Direction.Axis)state.m_61143_(AXIS));
        if (!newState.equals(state)) {
            worldIn.m_46597_(pos, newState);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, AXIS});
        for (BooleanProperty prop : CHAINED) {
            builder.m_61104_(new Property[]{prop});
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction action, boolean simulate) {
        if (action == ToolActions.AXE_STRIP) {
            return this.block != null ? BlockUtil.transferAllBlockStates(state, this.block.get().m_49966_()) : null;
        }
        return super.getToolModifiedState(state, context, action, simulate);
    }

    private BlockState getRelevantState(Level world, BlockPos pos, Direction.Axis axis) {
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_(AXIS, (Comparable)axis);
        for (Direction direction : Direction.values()) {
            BlockState sideState;
            if (direction.m_122434_() == axis || (!((sideState = world.m_8055_(pos.m_121945_(direction))).m_60734_() instanceof ChainBlock) || sideState.m_61143_((Property)BlockStateProperties.f_61365_) != direction.m_122434_()) && (direction != Direction.DOWN || !(sideState.m_60734_() instanceof LanternBlock) || !((Boolean)sideState.m_61143_((Property)LanternBlock.f_153459_)).booleanValue())) continue;
            state = (BlockState)state.m_61124_((Property)CHAINED[direction.ordinal()], (Comparable)Boolean.valueOf(true));
        }
        return state;
    }
}

